/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outerend.biomes;

import java.util.HashMap;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;

public class BiomeWrapper {
    public int grassColor = 0;
    public int skyColor = 0;
    public int waterColor = 0;
    public int waterFogColor = 0;
    public int fogColor = 0;
    public int foliageColor = 0;
    public float mobSpawnProbability = 0.5f;
    public float downfall = 0.0f;
    public float scale = 0.0f;
    public float temperature = 0.0f;
    public float depth = 0.0f;
    public Biome.Category category = Biome.Category.NONE;
    public Biome.RainType rainType = Biome.RainType.NONE;
    public BiomeGenerationSettings generationSettings = new BiomeGenerationSettingsBuilder(BiomeGenerationSettings.field_242480_b).func_242508_a();
    public final String modid;
    public final String name;
    public HashMap<MobSpawnInfo.Spawners, EntityClassification> spawners = new HashMap();

    public BiomeWrapper(ResourceLocation registryName) {
        this.modid = registryName.func_110624_b();
        this.name = registryName.func_110623_a();
    }

    public BiomeWrapper(ResourceLocation registryName, int grassColor, int skyColor, int waterColor, int waterFogColor, int fogColor, int foliageColor, float mobSpawnProbability, float downfall, float scale, float temperature, float depth, Biome.Category category, Biome.RainType rainType) {
        this.grassColor = grassColor;
        this.skyColor = skyColor;
        this.waterColor = waterColor;
        this.waterFogColor = waterFogColor;
        this.fogColor = fogColor;
        this.foliageColor = foliageColor;
        this.mobSpawnProbability = mobSpawnProbability;
        this.downfall = downfall;
        this.scale = scale;
        this.temperature = temperature;
        this.depth = depth;
        this.category = category;
        this.rainType = rainType;
        this.modid = registryName.func_110624_b();
        this.name = registryName.func_110623_a();
    }

    public BiomeWrapper withGenerationSettings(BiomeGenerationSettingsBuilder builder) {
        this.generationSettings = builder.func_242508_a();
        return this;
    }

    public BiomeWrapper withCategory(Biome.Category category) {
        this.category = category;
        return this;
    }

    public BiomeWrapper addSpawn(EntityClassification classification, MobSpawnInfo.Spawners spawners) {
        this.spawners.put(spawners, classification);
        return this;
    }

    private MobSpawnInfo generateMobSpawnList() {
        MobSpawnInfo.Builder[] builder = new MobSpawnInfo.Builder[]{new MobSpawnInfoBuilder(MobSpawnInfo.field_242551_b).func_242572_a(this.mobSpawnProbability)};
        this.spawners.forEach((spawner, classification) -> {
            builder[0] = builder[0].func_242575_a(classification, spawner);
        });
        return builder[0].func_242577_b();
    }

    public Biome build() {
        return (Biome)new Biome.Builder().func_205420_b(this.scale).func_205414_c(this.temperature).func_205419_a(this.category).func_205421_a(this.depth).func_205415_a(this.rainType).func_242458_a(this.generateMobSpawnList()).func_235097_a_(new BiomeAmbience.Builder().func_235239_a_(this.fogColor).func_242540_e(this.foliageColor).func_235246_b_(this.waterColor).func_235248_c_(this.waterFogColor).func_242539_d(this.skyColor).func_242541_f(this.grassColor).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_205417_d(this.downfall).func_242457_a(this.generationSettings).func_242455_a().setRegistryName(new ResourceLocation(this.modid, this.name));
    }
}

